%%%%% This code calculates coverage probabilities  after running "MainCode_Bootstrap_CIs.m" 
%%%%% See the online appendix of Han and Lee(2019)for the simulation design
%%%%% The user needs to designate a nominal level
%%%%% The number of simulation iterations should be the same as that in "MainCode_Bootstrap_CIs.m" 


clear; 
clc;

nominal = 0.05 ; 
m = 200; % Number of simulation iterations 


%% Decision1 : Using bootstrap SE %%

sd_ate_store = zeros(m,1) ;
sd_delta_store = zeros(m,1) ;
sd_alpha_store = zeros(m,1) ;
sd_beta_store = zeros(m,1) ;
sd_gamma_store = zeros(m,1) ;
sd_rho_store = zeros(m,1) ;


decision1_alpha_store = zeros(m,1) ;
decision1_gamma_store = zeros(m,1) ;
decision1_beta_store = zeros(m,1) ;
decision1_delta_store = zeros(m,1) ;
decision1_rho_store = zeros(m,1) ;
decision1_ate_store = zeros(m,1) ;

ci_ate_lb1_store = zeros(m,1) ;
ci_ate_ub1_store = zeros(m,1) ;


%% Decision2 : Using bootstrap percentile CI %%

decision2_alpha_store = zeros(m,1) ;
decision2_gamma_store = zeros(m,1) ;
decision2_beta_store = zeros(m,1) ;
decision2_delta_store = zeros(m,1) ;
decision2_rho_store = zeros(m,1) ;
decision2_ate_store = zeros(m,1) ;

ci_ate_lb2_store = zeros(m,1) ;
ci_ate_ub2_store = zeros(m,1) ;



for i= 1:m
    load(['Test_Semi_Bootstrap_500_5_0_0_k7_' num2str(i) '.mat']) ;
    
    alpha = theta(2) ;
    gamma = theta(3) ;
    beta = theta(5) ;
    delta = theta(6) ;
    rho = theta(7) ;
    
    bb = size(boot_semi_est, 1) ;
    boot_semi_theta = boot_semi_est(:, 1:kk) ;
    boot_semi_alpha = boot_semi_est(:, 2) ;
    boot_semi_gamma = boot_semi_est(:, 3) ;
    boot_semi_beta = boot_semi_est(:, 5) ;
    boot_semi_delta = boot_semi_est(:,6) ;
    boot_semi_rho = boot_semi_est(:,7) ;    
    
    
    
    
    %% CIs using normal approximation 
    
    mean_boot_semi_ate = mean(boot_semi_ate) ;
    demeansq_boot_semi_ate = (boot_semi_ate - (ones(bb,1)*mean_boot_semi_ate)).^2 ;
    var_boot_semi_ate = mean(demeansq_boot_semi_ate) ;
    sd_boot_semi_ate = sqrt(var_boot_semi_ate) ;
    
    sd_ate_store(i,1) = sd_boot_semi_ate ;
            

    ci_ate_lb1 = semi_ate_est_all + ( (norminv(nominal/2) * sd_ate_store(i,1)) ) ; 
    ci_ate_ub1 = semi_ate_est_all + ( (norminv(1 - nominal/2) * sd_ate_store(i,1)) ) ;          
   
    ci_ate_lb1_store(i,1) = ci_ate_lb1 ; 
    ci_ate_ub1_store(i,1) = ci_ate_ub1 ; 
    
    decision1_ate = (ate <= ci_ate_ub1) * (ate >= ci_ate_lb1) ; 
    decision1_ate_store(i,1) = decision1_ate;
    
    
    delta_hat = semi_theta_est_all(6) ;
    mean_boot_semi_delta = mean(boot_semi_delta) ;
    demeansq_boot_semi_delta = (boot_semi_delta - (ones(bb,1)*mean_boot_semi_delta)).^2 ;
    var_boot_semi_delta = mean(demeansq_boot_semi_delta) ;
    sd_boot_semi_delta = sqrt(var_boot_semi_delta) ;
    
    
    sd_delta_store(i,1) = sd_boot_semi_delta ;
          
    
    ci_delta_lb1 = delta_hat + ( (norminv(nominal/2) * sd_boot_semi_delta) ) ;
    ci_delta_ub1 = delta_hat + ( (norminv(1 - nominal/2) * sd_boot_semi_delta) ) ;
    
    decision1_delta = (delta <= ci_delta_ub1) * (delta >= ci_delta_lb1) ;
    decision1_delta_store(i,1)= decision1_delta;     
    
    alpha_hat = semi_theta_est_all(2) ;
    mean_boot_semi_alpha = mean(boot_semi_alpha) ;
    demeansq_boot_semi_alpha = (boot_semi_alpha - (ones(bb,1)*mean_boot_semi_alpha)).^2 ;
    var_boot_semi_alpha = mean(demeansq_boot_semi_alpha) ;
    sd_boot_semi_alpha = sqrt(var_boot_semi_alpha) ;
    
    
    sd_alpha_store(i,1) = sd_boot_semi_alpha ;
          
    
    ci_alpha_lb1 = alpha_hat + ( (norminv(nominal/2) * sd_boot_semi_alpha) ) ;
    ci_alpha_ub1 = alpha_hat + ( (norminv(1 - nominal/2) * sd_boot_semi_alpha) ) ;
    
 
    decision1_alpha = (alpha <= ci_alpha_ub1) * (alpha >= ci_alpha_lb1) ;
    decision1_alpha_store(i,1)= decision1_alpha;       
    
    
    gamma_hat = semi_theta_est_all(3) ;
    mean_boot_semi_gamma = mean(boot_semi_gamma) ;
    demeansq_boot_semi_gamma = (boot_semi_gamma - (ones(bb,1)*mean_boot_semi_gamma)).^2 ;
    var_boot_semi_gamma = mean(demeansq_boot_semi_gamma) ;
    sd_boot_semi_gamma = sqrt(var_boot_semi_gamma) ;    
    
    sd_gamma_store(i,1) = sd_boot_semi_gamma ;
    
    ci_gamma_lb1 = gamma_hat + ( (norminv(nominal/2) * sd_boot_semi_gamma) ) ;
    ci_gamma_ub1 = gamma_hat + ( (norminv(1 - nominal/2) * sd_boot_semi_gamma) ) ;
     
    decision1_gamma = (gamma <= ci_gamma_ub1) * (gamma >= ci_gamma_lb1) ;
    decision1_gamma_store(i,1)= decision1_gamma;   
    
        
    beta_hat = semi_theta_est_all(5) ;
    mean_boot_semi_beta = mean(boot_semi_beta) ;
    demeansq_boot_semi_beta = (boot_semi_beta - (ones(bb,1)*mean_boot_semi_beta)).^2 ;
    var_boot_semi_beta = mean(demeansq_boot_semi_beta) ;
    sd_boot_semi_beta = sqrt(var_boot_semi_beta) ;
    
    
    sd_beta_store(i,1) = sd_boot_semi_beta ;
          
    
    ci_beta_lb1 = beta_hat + ( (norminv(nominal/2) * sd_boot_semi_beta) ) ;
    ci_beta_ub1 = beta_hat + ( (norminv(1 - nominal/2) * sd_boot_semi_beta) ) ;
    
    
    decision1_beta = (beta <= ci_beta_ub1) * (beta >= ci_beta_lb1) ;
    decision1_beta_store(i,1)= decision1_beta;    
    
    rho_hat = semi_theta_est_all(7) ;
    mean_boot_semi_rho = mean(boot_semi_rho) ;
    demeansq_boot_semi_rho = (boot_semi_rho - (ones(bb,1)*mean_boot_semi_rho)).^2 ;
    var_boot_semi_rho = mean(demeansq_boot_semi_rho) ;
    sd_boot_semi_rho = sqrt(var_boot_semi_rho) ;
    
    
    sd_rho_store(i,1) = sd_boot_semi_rho ;
          
    
    ci_rho_lb1 = rho_hat + ( (norminv(nominal/2) * sd_boot_semi_rho) ) ;
    ci_rho_ub1 = rho_hat + ( (norminv(1 - nominal/2) * sd_boot_semi_rho) ) ;
    
    
    decision1_rho = (rho <= ci_rho_ub1) * (rho >= ci_rho_lb1) ;
    decision1_rho_store(i,1)= decision1_rho;  
    
    
    %% Percentile Bootstrap CIs
    
    ci_ate_lb2 = quantile(boot_semi_ate, nominal/2) ;
    ci_ate_ub2 = quantile(boot_semi_ate, 1 - nominal/2) ;
    
    ci_ate_lb2_store(i,1) = ci_ate_lb2 ; 
    ci_ate_ub2_store(i,1) = ci_ate_ub2 ; 
    
    decision2_ate = (ate <= ci_ate_ub2) * (ate >= ci_ate_lb2) ; 
    decision2_ate_store(i,1) = decision2_ate; 
    
    
    ci_delta_lb2 = quantile(boot_semi_delta, nominal/2) ;
    ci_delta_ub2 = quantile(boot_semi_delta, 1 - nominal/2) ;
    decision2_delta = (delta <= ci_delta_ub2) * (delta >= ci_delta_lb2) ;    
    decision2_delta_store(i,1) = decision2_delta; 
    
    
    ci_alpha_lb2 = quantile(boot_semi_alpha, nominal/2) ;
    ci_alpha_ub2 = quantile(boot_semi_alpha, 1 - nominal/2) ;
    decision2_alpha = (alpha <= ci_alpha_ub2) * (alpha >= ci_alpha_lb2) ;
    decision2_alpha_store(i,1) = decision2_alpha;     
    
    ci_gamma_lb2 = quantile(boot_semi_gamma, nominal/2) ;
    ci_gamma_ub2 = quantile(boot_semi_gamma, 1 - nominal/2) ;
    decision2_gamma = (gamma <= ci_gamma_ub2) * (gamma >= ci_gamma_lb2) ;    
    decision2_gamma_store(i,1) = decision2_gamma; 
        
    ci_beta_lb2 = quantile(boot_semi_beta, nominal/2) ;
    ci_beta_ub2 = quantile(boot_semi_beta, 1 - nominal/2) ;
    decision2_beta = (beta <= ci_beta_ub2) * (beta >= ci_beta_lb2) ;
    decision2_beta_store(i,1) = decision2_beta ;
        
    ci_delta_lb2 = quantile(boot_semi_delta, nominal/2) ;
    ci_delta_ub2 = quantile(boot_semi_delta, 1 - nominal/2) ;
    decision2_delta = (delta <= ci_delta_ub2) * (delta >= ci_delta_lb2) ;    
    decision2_delta_store(i,1) = decision2_delta; 
    
    ci_rho_lb2 = quantile(boot_semi_rho, nominal/2) ;
    ci_rho_ub2 = quantile(boot_semi_rho, 1 - nominal/2) ;
    decision2_rho = (rho <= ci_rho_ub2) * (rho >= ci_rho_lb2) ;    
    decision2_rho_store(i,1) = decision2_rho; 
    
        
    
end

decision_ate = [decision1_ate_store, decision2_ate_store] ;
decision_delta = [decision1_delta_store, decision2_delta_store] ;
decision_alpha = [decision1_alpha_store, decision2_alpha_store];
decision_gamma = [decision1_gamma_store, decision2_gamma_store];
decision_beta = [decision1_beta_store, decision2_beta_store];
decision_rho = [decision1_rho_store, decision2_rho_store] ;


cp_ate_table = mean(decision_ate) ;
cp_delta_table = mean(decision_delta) ;
cp_alpha_table = mean(decision_alpha) ;
cp_gamma_table = mean(decision_gamma) ;
cp_beta_table = mean(decision_beta) ;
cp_rho_table = mean(decision_rho) ;


cp_ate_table
cp_delta_table
cp_alpha_table
cp_gamma_table
cp_beta_table
cp_rho_table

save(sprintf('CP_Semi_Bootstrap_%d_%d_%d.mat',n,bb,m), 'cp_ate_table', 'cp_delta_table', 'cp_alpha_table', 'cp_gamma_table', 'cp_beta_table', 'cp_rho_table', 'decision_ate', 'decision_delta', 'decision_alpha', 'decision_gamma', 'decision_beta', 'decision_rho') ;





